/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.object;

public final class PropertyChangeListener<T, C> {
    private final IPropertyGetter<T, C> propertyGetter;
    private final IChangeCallback<T, C> callback;
    private final IPropertyComparator<T> comparator;
    private T lastPropState;

    public PropertyChangeListener(IPropertyGetter<T, C> propertyGetter, IChangeCallback<T, C> callback) {
        this(propertyGetter, callback, PropertyChangeListener::defaultCompare);
    }

    public PropertyChangeListener(IPropertyGetter<T, C> propertyGetter, IChangeCallback<T, C> callback, IPropertyComparator<T> comparator) {
        this.propertyGetter = propertyGetter;
        this.callback = callback;
        this.comparator = comparator;
    }

    public void refresh(C context) {
        T prop = this.propertyGetter.getProperty(context);
        if (!this.comparator.isSame(this.lastPropState, prop)) {
            this.lastPropState = prop;
            this.callback.onPropertyChanged(prop, context);
        }
    }

    public void scheduleUpdate() {
        this.lastPropState = null;
    }

    private static <T> boolean defaultCompare(T p1, T p2) {
        boolean nonnull = p1 != null && p2 != null;
        return nonnull && p1.equals(p2);
    }

    @FunctionalInterface
    public static interface IPropertyComparator<T> {
        public boolean isSame(T var1, T var2);
    }

    @FunctionalInterface
    public static interface IChangeCallback<T, C> {
        public void onPropertyChanged(T var1, C var2);
    }

    @FunctionalInterface
    public static interface IPropertyGetter<T, C> {
        public T getProperty(C var1);
    }
}

